                                                                                                    
    'SD CARD FORMAT: RIGHT CLICK SD CARD DRIVE LETTER AND FORMAT "FAT" OR "FAT16" NOT "FAT32" 
    
    'Legal characters for DOS filenames include the following:
    'Upper case letters AZ 
    'Numbers 09
    'Trailing spaces only
    ' ! # $ % & ' ( ) - @ ^ _ ` { } ~ 
    
    
    'ADD FILES TO SD CARD ONE AT A TIME IN ORDER OF FILE PREFERANCE
    'APPEARANCE OF SD CARD FILE ORDER IN WINDOWS DOES NOT REFLECT ACTUAL FILE ORDER
     
    'PROTON COMPILER v3.2.5.5 
        
    
'    '********** UNCOMMENT DEVICE AND @ LINES FOR 18F452 **********
'    Device = 18F452
'    @CONFIG_REQ
'    '    ifdef PLL@REQ ; Do we require the PLL ?
'            @__config config1h, OSCS_OFF_1 & HSPLL_OSC_1
'    '    else
'    '        @__config CONFIG1H, OSCS_OFF_1 & HS_OSC_1
'    '    endif
'            @__config config2l, BOR_ON_2 & BORV_20_2 & PWRT_ON_2
'    '    ifdef WATCHDOG_REQ
'    '        @__config CONFIG2H, WDT_ON_2 & WDTPS_128_2
'    '    else
'            @__config config2h, WDT_OFF_2 & WDTPS_128_2
'    '    endif
'            @__config config3h, CCP2MX_ON_3
'    '    ifdef DEBUG@REQ ; Do we require DEBUG ?
'    '        @__config CONFIG4L, STVR_ON_4 & LVP_OFF_4 & DEBUG_ON_4
'    '    else
'            @__config config4l, STVR_ON_4 & LVP_OFF_4 & DEBUG_OFF_4
'    '    endif
'    'COMMENT OUT ALL ABOVE IN C:\Program Files\Crownhill\PDS\Inc\P18F452.lpb
                  
                  
 
 
    '********** UNCOMMENT DEVICE AND @ LINES FOR 18F4520 **********
    Device = 18F4520
    @CONFIG_REQ 
      '      ifdef PLL@REQ                                 
      '      Do we require the PLL ?
                @__config config1h, OSC_HSPLL_1
      '      else
      '          @__config CONFIG1H, OSC_HS_1
      '      endif
                @__config config2l, BOREN_ON_2 & BORV_21_2 & PWRT_ON_2
      '      ifdef WATCHDOG_REQ                             

      '      ; Do we require the WATCHDOG ?
      '          @__config config2h, WDT_ON_2 & WDTPS_128_2
      '      else
                @__config config2h, WDT_OFF_2 & WDTPS_128_2
      '      endif
                @__config config3h, CCP2MX_PORTC_3 & PBADEN_OFF_3 & MCLRE_ON_3
      '      ifdef DEBUG@REQ                             

      '      ; Do we require DEBUG ?
      '          @__config CONFIG4L, LVP_OFF_4 & DEBUG_ON_4 & XINST_OFF_4
      '      else
                @__config config4l, LVP_OFF_4 & DEBUG_OFF_4 & XINST_OFF_4
      '      endif
            @__config config5l, CP0_OFF_5 & CP1_OFF_5 & CP2_OFF_5
            @__config config5h, CPB_OFF_5 & CPB_OFF_5
            @__config config6l, WRT0_OFF_6 & WRT1_OFF_6 & WRT2_OFF_6
            @__config config6h, WRTC_OFF_6 & WRTB_OFF_6 & WRTD_OFF_6
            @__config config7l, EBTR0_OFF_7 & EBTR1_OFF_7 & EBTR2_OFF_7
            @__config config7h, EBTRB_OFF_7 
     
 
    
'    '********** UNCOMMENT DEVICE AND @ LINES FOR 18F4620 **********
'    Device = 18F4620
'    @CONFIG_REQ
'    '    ifdef PLL@REQ                                             ; Do we require the PLL ?
'            @__config config1h, HSPLL_OSC_1
'    '    else
'    '        @__config CONFIG1H, HS_OSC_1
'    '    endif
'            @__config config2l, BOREN_ON_2 & BORV_25_2 & PWRT_ON_2
'    '    ifdef WATCHDOG_REQ                                         ; Do we require the WATCHDOG ?
'    '        @__config CONFIG2H, WDT_ON_2 & WDTPS_128_2
'    '    else
'            @__config config2h, WDT_OFF_2 & WDTPS_128_2
'    '    endif
'            @__config config3h, CCP2MX_PORTC_3 & MCLRE_ON_3 & PBADEN_OFF_3
'    '    ifdef DEBUG@REQ                                         ; Do we require DEBUG ?
'    '        @__config CONFIG4L, STVR_ON_4 & LVP_OFF_4 & ENHCPU_OFF_4 & DEBUG_ON_4
'    '    else
'            @__config config4l, STVR_ON_4 & LVP_OFF_4 & ENHCPU_OFF_4 & DEBUG_OFF_4
'    '    endif
'        @__config config5l, CP0_OFF_5 & CP1_OFF_5 & CP2_OFF_5
'        @__config config5h, CPB_OFF_5 & CPB_OFF_5
'        @__config config6l, WRT0_OFF_6 & WRT1_OFF_6 & WRT2_OFF_6
'        @__config config6h, WRTC_OFF_6 & WRTB_OFF_6 & WRTD_OFF_6
'        @__config config7l, EBTR0_OFF_7 & EBTR1_OFF_7 & EBTR2_OFF_7
'        @__config config7h, EBTRB_OFF_7
'    'COMMENT OUT ALL ABOVE IN C:\Program Files\Crownhill\PDS\Inc\P18F4620.lpb    
 
 
                           
                        
    OPTIMISER_LEVEL = 6   
        
    XTAL = 40      ' REQUIRES PLL  ' USE 10 MHz CRYSTAL & DECLARE: XTAL = 40
    
    Clear
    
    Symbol sSEROUT_PIN = PORTA.2 
    Symbol sBAUD = 16416  '16416 = 19200 BAUD   'MENU
    
    'RESITOR DIVIDER  5vPIC > 2.2K > 2.9V > 3.0K > GND    
    Symbol sSD_CS = PORTC.2    
    Symbol sMENU_PLAY_BUTTON = PORTE.2
    Symbol TRUE = 1
    Symbol FALSE = 0
    Symbol sRETURN_ERROR = 1
    Symbol sRETURN_NO_ERROR = 0
    
    Dim ySD_Root_Dir_File32[32] As Byte 
    Dim dWRITE_BUFF_TOTAL As DWord
    Dim yAHEAD As Byte
    Dim yREAD_BUFF_PT As Byte 
    Dim wBuffer_Size As Word 
    Dim yTEMP  As Byte   
    Dim dLOW_BUFFER_ERROR As DWord
    Dim wTIMER1 As TMR1L.Word      'access 16 bits of TMR1
    Dim yBUFF_ARRAY256[256] As Byte 
    Dim dSECTOR_START As DWord
    Dim wTWOS_COMPLEMENT As Word
    Dim wTWOS_COMPLEMENT_PREV As Word 

    Dim y1 As Byte
    Dim y2 As Byte
    Dim w1 As Word
    
    Dim dSD_Sector_Num As DWord                                                 
    Dim ySD_Byte0 As Byte                                                             
    Dim ySD_Byte1 As Byte 
    Dim ySD_Byte2 As Byte 
    Dim ySD_Byte3 As Byte 
    Dim ySD_Byte4 As Byte 
    Dim ySD_Byte5 As Byte 
    Dim wSD_Boot_Record As Word 
    Dim wSD_Bytes_Per_Sec As Word 
    Dim ySD_Secs_Per_Cluster As Byte 
    Dim ySD_Num_of_FATs As Byte 
    Dim wSD_Secs_Per_FAT As Word 
    Dim wSD_Reserved_Secs As Word 
    Dim dSD_Root_Dir As DWord
    Dim ySD_Idx As Byte 
    Dim dSD_Address As DWord
    Dim ySD_Seek_Response_Reqd As Byte 
    Dim iSD_Return As Bit 
    Dim ySD_ByteR As Byte
    Dim wSD_Seek_Response_Idx As Word  
    Dim ySD_Seek_Response_Return As Byte 
    Dim iSD_Extended_Return As Bit
    Dim wSD_Num_of_Root_Entries As Word 
    Dim wSD_Secs_in_Root As Word  
    Dim ySD_Root_Dir_File_Pos As Byte  
    Dim ySD_Extended_Return_Root_Dir As Byte
    Dim dSD_File_Size As DWord
    Dim wSD_Cluster_Num As Word
    Dim dSD_Data_Sec As DWord
    Dim dSD_Data_Area As DWord
    Dim yCOUNT_NULLS As Byte
    Dim wFILES_TOTAL As Word   
    
    Dim wFILE_PLAY As Word    
    Dim yPLAYALL_SHUFFLE_BMP_TOTAL3 As Byte  
    Dim wFILE_DISPLAY As Word      
    Dim yERROR_LOOP_CNT As Byte
    Dim yERROR_LOOP_CNT_STOP_PLAY As Byte
    Dim yERROR_LOOP_CNT_INIT_SD As Byte
    Dim yERROR_LOOP_CNT_PLAY_WAV As Byte
 
    Dim iSTART_POP_ELIMINATE As Bit
    Dim st_STRING_1_CHAR As String * 1
    Dim yFILE_NAME_EXT3[3] As Byte
    Dim iWAV_EXT As Bit
    Dim iBIT As Bit
    Dim s_LCD_STRING_1plus8 As String * 8 

    Dim dSD_Sec_Num_PLUS As DWord
    Dim dREAD_ROOT_START_PT As DWord
    Dim dREAD_ROOT_END_PT As DWord
    Dim yROOT454_READ As Byte
    Dim yROOT0_READ As Byte
    Dim yROOT2_READ As Byte
    Dim yROOT_READ13[13] As Byte
    Dim yROOT_ERROR_CNT As Byte
    Dim iFIRSTRUN_COUNT_ALL As Bit    
    iFIRSTRUN_COUNT_ALL = TRUE
       
    Dim iDISPLAY16 As Bit
    Dim iMENU_PLAY_BUTTON_UP As Bit
    
    
    
    ALL_DIGITAL = TRUE 
                                                                                                            
    '********************
    'MSSP = MASTER SYNCHROUS SERIAL PORT MODULE ' SPI Port Setup
    'SSPSTAT = %11000000   'BOTH WORK SD card
    SSPSTAT = %01000000  'BOTH WORK SD card
    SSPCON1 = %00100010 ' SLOW    INITILIZE SLOW  
      
    '********************
    'INTERRUPT REGISTER'S
    RCON.7 = 0   ' 0 DISABLES PRIORITY LEVELS ON INTERRUPTS (16F COMPATABILITY)
    T1CON = %10000000   '%xx0$xxx = 1:1 PRESCALE
                        'T1CON.0 = 0   ' 0 = TIMER 1 OFF                            
    PIE1 = %00000001    'enable TMR1 overflow interrupt
    INTCON = %11000000  'enable global and peripheral interrupts 
    
    ON_HARDWARE_INTERRUPT GoTo SET_PORT_HARDWARE_INTERRUPT  
           
    '********************
    TRISA.5 = 0 
    TRISA.4 = 1                       
    TRISA.3 = 1
    TRISA.2 = 0
    TRISA.1 = 0   
    TRISA.0 = 0
    TRISB=%00000000
    TRISC=%00010000   ' xxx1xxxx MSSP SPI data in
    TRISD=%00000000
    TRISE.2 = 1
    TRISE.1 = 1
    TRISE.0 = 1
                                              
    GoTo START    'Jump over the subroutines

    
    '********** ASSEMBLY HARDWARE TMR 1 Interrupt **********
    SET_PORT_HARDWARE_INTERRUPT:

    '16 BIT MONO ''''''''''''''''''''''''    
    '  7  6  5  4  3  2  1  0 15 14 13 12 11 10  9  8
    '+-----------------------+-----------------------+
    '| lsb     byte 0        |       byte 1      msb |
    '+-----------------------+-----------------------+ 
    
    If yAHEAD > 1 Then   '2 MIN FOR 16 BIT
    
        If iSTART_POP_ELIMINATE = FALSE Then 'SKIP PLAY TO ELIMINATE POP 
            wTWOS_COMPLEMENT.LowByte = yBUFF_ARRAY256[yREAD_BUFF_PT]  
            Inc yREAD_BUFF_PT
            wTWOS_COMPLEMENT.HighByte = yBUFF_ARRAY256[yREAD_BUFF_PT]  
            Inc yREAD_BUFF_PT
             
            If wTWOS_COMPLEMENT <= 32767 Then  ' POSITIVE
                wTWOS_COMPLEMENT = wTWOS_COMPLEMENT + 32768
            Else   ' NEGITIVE
                wTWOS_COMPLEMENT = wTWOS_COMPLEMENT - 32768
            EndIf
            
            If wTWOS_COMPLEMENT > 64224 Then  'SPIKE  64224 IS 98% OF WORD 
                wTWOS_COMPLEMENT = wTWOS_COMPLEMENT_PREV
            Else
                wTWOS_COMPLEMENT_PREV = wTWOS_COMPLEMENT
            EndIf    
             
            PORTB = wTWOS_COMPLEMENT.HighByte
            PORTD = wTWOS_COMPLEMENT.LowByte
        Else
             yREAD_BUFF_PT = yREAD_BUFF_PT +2
        EndIf
    Else
        Inc dLOW_BUFFER_ERROR
    EndIf
    'clear interrupt flag and exit...   
    bcf PIR1,0 
   
    wTIMER1 = 65380 '18F4620
    retfie fast 
    '********** END ASSEMBLY HARDWARE TMR 1 Interrupt **********
    
    
    subPLAY_WAV_SD: '************************
    yERROR_LOOP_CNT_PLAY_WAV = 50    
    Repeat 
        GoSub subSD_Read_Sector_MULTIBLOCK  
        If yERROR_LOOP_CNT_PLAY_WAV <> 50 Then
        EndIf
        Dec yERROR_LOOP_CNT_PLAY_WAV
    Until iSD_Return = sRETURN_NO_ERROR Or yERROR_LOOP_CNT_PLAY_WAV = 0 
    
    If yERROR_LOOP_CNT_PLAY_WAV > 0 Then       
    Else
        SerOut sSEROUT_PIN,sBAUD,[13," FATAL subSD_Read_Sector_MULTIBLOCK ERROR",13]
        DelayMS 100
        Stop
    EndIf
  
    SSPCON1 = %00100000 'FAST   
'    SSPCON1 = %00100001 ' MED   '2GIG (SLOWER NON 133X) SD CARD WORKS OK BUT READS TOO SLOW FOR MUSIC
         
    iSTART_POP_ELIMINATE = TRUE
    
    'EOF POP ELIMINATE
    If dSD_File_Size > 2000 + 512 +10 Then
        dSD_File_Size = dSD_File_Size - 2000 ' MUST BE > 512 FOR LATE EXIT AT REPEAT/UNTIL     
    EndIf
    
    yREAD_BUFF_PT = 0
    dLOW_BUFFER_ERROR = 0 
    wTIMER1 = 0  'FILL BUFFER
    dWRITE_BUFF_TOTAL = 0
    
    T1CON.0 = 1   ' 1 = TIMER 1 ON          
    yTEMP = $FE  'FIRST SECTOR 
    
    Repeat '[[[[[[[[[[ 
         
        wBuffer_Size = 0                
                      
        While yTEMP <> $FE   'SAME SPEED AS While SSPBUF != $FE   
            SSPBUF = $FF              'SENDS 1 BYTE TO SD
            While SSPSTAT.0 = 0: Wend 'WHILE TX/RX COMPLETE
            yTEMP  = SSPBUF
        Wend                   ' for $FE Data token, and if found then proceed  

        Repeat  '{{{{{{{{{{{{{{   READ SECTOR (BLOCK) 'Until wBuffer_Size = 512       
        
            Repeat  
                If dWRITE_BUFF_TOTAL.BYTE0 >= yREAD_BUFF_PT Then          
                    yAHEAD = dWRITE_BUFF_TOTAL.BYTE0 - yREAD_BUFF_PT 
                Else
                    yAHEAD =  dWRITE_BUFF_TOTAL.BYTE0 + 256 - yREAD_BUFF_PT ' dWRITE_BUFF_TOTAL.BYTE0 ROLLOVER
                EndIf
                  
                ''''''''' ADJUST ''''''''''     
                Repeat             ' HIGH END
'                    Until wTIMER1 < 65536 'DOSN'T RUN 18F4520 16BIT INT=65380
'                    Until wTIMER1 < 65535 'DOES  RUN 18F4520 16BIT INT=65380
                Until wTIMER1 < 65512  'MID POINT
'                    Until wTIMER1 < 65489 'BUFFER = 253 18F4520 16BIT INT=65380
'                    Until wTIMER1 < 65488 'BUFFER < 253 18F4520 16BIT INT=65380
                                   ' LOW END
                ''''''''' ADJUST ''''''''''      
             
            Until yAHEAD <> 255 'UNTIL BUFFER NOT FULL
                       
            SSPBUF = $FF              'SENDS 1 BYTE TO SD
            While SSPSTAT.0 = 0: Wend 'WHILE TX/RX COMPLETE
            yBUFF_ARRAY256[dWRITE_BUFF_TOTAL.BYTE0] = SSPBUF 'READS 1 BYTE FROM SD   READ IMMEADIATLY 
            Inc dWRITE_BUFF_TOTAL           'BYTE0 LOOPS 0 TO 255
            
            'IN PLACE OF A COUNTER IN INTERRUPT    
            If dWRITE_BUFF_TOTAL.BYTE1 = 3 Then '3  DO NOT USE ">" SOUNDS FUZZY, "=" FASTER
                iSTART_POP_ELIMINATE = FALSE
            EndIf
             
            Inc wBuffer_Size                                 'Move up one byte            
        Until wBuffer_Size.HighByte = 2    '}}}}}}}}}}}}  'highbyte 2 = 512 = SECTOR COMPLETE    
        
        '2 DUMMY CRC BYTES
        SSPBUF = $FF              'SENDS 1 BYTE TO SD
        While SSPSTAT.0 = 0: Wend 'WHILE TX/RX COMPLETE 
        yTEMP  = SSPBUF
        
        SSPBUF = $FF              'SENDS 1 BYTE TO SD
        While SSPSTAT.0 = 0: Wend 'WHILE TX/RX COMPLETE       
        yTEMP  = SSPBUF
        
         If iMENU_PLAY_BUTTON_UP = TRUE Then
            If sMENU_PLAY_BUTTON = 0 Then 
            
                T1CON.0 = 0   ' 0 = TIMER 1 OFF FOR FOLLOWING SEROUT
                SerOut sSEROUT_PIN,sBAUD,[" IN PLAY STOPPED, BUFF yAHEAD = ",Dec yAHEAD," OF 255",13]
                
                GoSub subSTOP_PLAY_WAV_SD
                Return
            EndIf 
        Else
            If sMENU_PLAY_BUTTON = 1 Then 
                iMENU_PLAY_BUTTON_UP = TRUE
            EndIf     
        EndIf
  
        yTEMP  = $FF  'AFTER FIRST SECTOR
    Until dWRITE_BUFF_TOTAL >= dSD_File_Size 'FILE SIZE IS REDUCED For ENDOF FILE Pop SO LATE End Not HURT  
                      
    Repeat  'LET TIMER EMTY BUFFER
        If dWRITE_BUFF_TOTAL.BYTE0 >= yREAD_BUFF_PT Then          
            yAHEAD = dWRITE_BUFF_TOTAL.BYTE0 - yREAD_BUFF_PT 
        Else
            yAHEAD =  dWRITE_BUFF_TOTAL.BYTE0 + 256 - yREAD_BUFF_PT ' dWRITE_BUFF_TOTAL.BYTE0 ROLLOVER
        EndIf
    Until yAHEAD < 2  'STEREO 'INT PLAY'S BY 2's   FILE LENGTH COULD BE ODD 

    GoSub subSTOP_PLAY_WAV_SD   
    
    Return 
    '********** END subPLAY_WAV_SD **********


    subSTOP_PLAY_WAV_SD: '************************

    T1CON.0 = 0   ' 0 = TIMER 1 OFF     
    SSPCON1 = %00100010 ' SLOW
    
    yERROR_LOOP_CNT_STOP_PLAY = 50    
    Repeat 
        GoSub subSD_STOP_READ_MULTIBLOCK  'DOES  HIGH sSD_CS  
        Dec yERROR_LOOP_CNT_STOP_PLAY
    Until iSD_Return = sRETURN_NO_ERROR Or yERROR_LOOP_CNT_STOP_PLAY = 0 
    
    If yERROR_LOOP_CNT_STOP_PLAY = 0 Then       
        SerOut sSEROUT_PIN,sBAUD,[13,"FATAL subSD_STOP_READ_MULTIBLOCK ERROR",13]
        DelayMS 100
        Stop
    EndIf

    If dLOW_BUFFER_ERROR > 0 Then 
        SerOut sSEROUT_PIN,sBAUD,["**ERROR** SLOWPLAY** dLOW_BUFFER_ERROR = ",Dec dLOW_BUFFER_ERROR,13]
    EndIf    
         
    Return     
    '********** END subSTOP_PLAY_WAV_SD **********
    

    subINIT_SD: '************************
    yERROR_LOOP_CNT_INIT_SD = 50    
    Repeat 
        GoSub subSD_Init_FS_MSSP_Sub 
        Dec yERROR_LOOP_CNT_INIT_SD   
    Until iSD_Extended_Return = sRETURN_NO_ERROR Or yERROR_LOOP_CNT_INIT_SD = 0 
    
    If yERROR_LOOP_CNT_INIT_SD > 0 Then       
        SerOut sSEROUT_PIN,sBAUD,[13," SD CARD FOUND",13]
    Else
        SerOut sSEROUT_PIN,sBAUD,[13," SD CARD NOT FOUND",13]
        SerOut sSEROUT_PIN,sBAUD,[" INSERT SD CARD AND RESET",13]
        DelayMS 100
        Stop
    EndIf
    Return
    '********** END subINIT_SD **********
   
   
    subSD_Init_FS_MSSP_Sub: '************************ 'IS FILE SYSTEM SUB
    GoSub subSD_Init_MSSP_Sub 
                                     
    If iSD_Return = sRETURN_ERROR Then
        iSD_Extended_Return = sRETURN_ERROR 
        Return 
    EndIf 
        
    dSD_Sector_Num = $00 
    GoSub subSD_Read_Sector
    
    If iSD_Return = sRETURN_ERROR Then
        iSD_Extended_Return = sRETURN_ERROR 
        Return 
    EndIf 
       
    If yROOT0_READ = $EB And yROOT2_READ = $90 Then 
        wSD_Boot_Record = $0000                                                   
    ElseIf yROOT0_READ = $E9 Then 
        wSD_Boot_Record = $0000                                                   
    Else 
        wSD_Boot_Record = yROOT454_READ                                    
    EndIf
                                                                                        
    dSD_Sector_Num = wSD_Boot_Record 

    GoSub subSD_Read_Sector 
    
    If iSD_Return = sRETURN_ERROR Then
        iSD_Extended_Return = sRETURN_ERROR 
        Return 
    EndIf
                 
    wSD_Bytes_Per_Sec.BYTE0 = yROOT_READ13[0] '11                                    
    wSD_Bytes_Per_Sec.BYTE1 = yROOT_READ13[1] '12
                                       
    ySD_Secs_Per_Cluster = yROOT_READ13[2] '13
                                       
    wSD_Reserved_Secs.BYTE0 = yROOT_READ13[3]  '14                                   
    wSD_Reserved_Secs.BYTE1 = yROOT_READ13[4]  '15                                         
    ySD_Num_of_FATs = yROOT_READ13[5]  '16
                                               
    wSD_Num_of_Root_Entries.BYTE0 = yROOT_READ13[6]  '17                             
    wSD_Num_of_Root_Entries.BYTE1 = yROOT_READ13[7]  '18
           
    wSD_Secs_Per_FAT.BYTE0 = yROOT_READ13[11]  '22                                    
    wSD_Secs_Per_FAT.BYTE1 = yROOT_READ13[12]  '23   
            
    dSD_Root_Dir = ySD_Num_of_FATs * wSD_Secs_Per_FAT                               
    dSD_Root_Dir = wSD_Boot_Record + wSD_Reserved_Secs + dSD_Root_Dir 

    wSD_Secs_in_Root = wSD_Num_of_Root_Entries * 32                                
    wSD_Secs_in_Root = wSD_Secs_in_Root / wSD_Bytes_Per_Sec 
    
    dSD_Data_Area = dSD_Root_Dir + wSD_Secs_in_Root                                 
    iSD_Extended_Return = sRETURN_NO_ERROR 
    
    Return 
    '********** END subSD_Init_FS_MSSP_Sub **********


    subSD_Init_MSSP_Sub: '************************ 'NOT FILE SYSTEM SUB                   
    High sSD_CS                                                                   
    ySD_Byte0 = $FF 
    ySD_Byte1 = $FF 
    ySD_Byte2 = $FF 
    ySD_Byte3 = $FF 
    ySD_Byte4 = $FF 
    ySD_Byte5 = $FF 
    GoSub subSD_Send_Cmd     'WAKEUP
    GoSub subSD_Send_Cmd 

    DelayMS 10 
    Low sSD_CS                                                                    
    ySD_Byte0 = $40    '$40 = %01 000000   '000000 = GO_IDLE_STATE  (CMD 0) 
    ySD_Byte1 = $00 
    ySD_Byte2 = $00 
    ySD_Byte3 = $00 
    ySD_Byte4 = $00 
    ySD_Byte5 = $95    'CRC ONLY REQUIRED ONCE TO CONVERT TO SPI MODE 
    GoSub subSD_Send_Cmd 
    ySD_Seek_Response_Reqd = $01
    GoSub subSD_Seek_Response 
    If ySD_Seek_Response_Return = sRETURN_ERROR Then  
        High sSD_CS  
        iSD_Return = sRETURN_ERROR                                                        
        Return 
    EndIf   
 
    ySD_Idx = $FF 
    Repeat 
        ySD_Byte0 = $41    '$41 = %01 000001   '000001 = INITIALISE SD  (CMD 1)  
        ySD_Byte1 = $00 
        ySD_Byte2 = $00 
        ySD_Byte3 = $00 
        ySD_Byte4 = $00 
        ySD_Byte5 = $FF     
        GoSub subSD_Send_Cmd        
        ySD_Seek_Response_Reqd = $00
        GoSub subSD_Seek_Response 
        Dec ySD_Idx 
    Until ySD_Seek_Response_Return = sRETURN_NO_ERROR Or ySD_Idx = 0 
    If ySD_Idx = 0 Then 
        High sSD_CS   
        iSD_Return = sRETURN_ERROR                                                        
        Return
    EndIf

    High sSD_CS 
    ySD_Byte5 = $FF 

    GoSub subSD_Send_Byte                                                          
    iSD_Return = sRETURN_NO_ERROR

    Return 
    '********** END subSD_Init_MSSP_Sub **********  
    
    
    subSD_Read_Sector: '************************    
    yERROR_LOOP_CNT = 0 
              
    LOOP_READ1_SEC:
                                                                      
    dSD_Address = dSD_Sector_Num << 9  
    Low sSD_CS
 
    ySD_Byte0 = $51   '$51 = %01 010001   '010001 = READ ONE BLOCK  (CMD 17) 
    ySD_Byte1 = dSD_Address.BYTE3 
    ySD_Byte2 = dSD_Address.BYTE2 
    ySD_Byte3 = dSD_Address.BYTE1 
    ySD_Byte4 = dSD_Address.BYTE0 
    ySD_Byte5 = $FF
    
    LOOP_READ2_SEC:
           
    GoSub subSD_Send_Cmd 

    ySD_Seek_Response_Reqd = $00 
    GoSub subSD_Seek_Response 
    If ySD_Seek_Response_Return = sRETURN_ERROR Then 
        High sSD_CS 
    
        Inc yERROR_LOOP_CNT        
        If yERROR_LOOP_CNT < 10 Then  
            GoTo LOOP_READ1_SEC 
        EndIf
       
        SerOut sSEROUT_PIN,sBAUD,["subSD_Read_Sector LOOPED OUT  ***RESETTING***",13]
        DelayMS 100
        iSD_Return = sRETURN_ERROR
        reset  'SD CARD REMOVED?
        Return
    EndIf 
    
    ySD_Seek_Response_Reqd = $FE 
    GoSub subSD_Seek_Response 

    If ySD_Seek_Response_Return = sRETURN_ERROR Then 
        Inc yERROR_LOOP_CNT
        If yERROR_LOOP_CNT < 25 Then 
            GoTo LOOP_READ2_SEC
        EndIf

        iSD_Return = sRETURN_ERROR                                                 
        Return
    EndIf 
     
    dREAD_ROOT_END_PT = dREAD_ROOT_START_PT + 31
    
    y1 = 0
    y2 = 0       '0 TO 255($FF) = 256 BYTES * 2 = 512
    For w1 = 0 To 511            '0 TO 511 = 512 BYTES
    
        GoSub subSD_Receive_Byte
        
        If w1 >= dREAD_ROOT_START_PT And w1 <= dREAD_ROOT_END_PT Then
             ySD_Root_Dir_File32[y1] = ySD_ByteR
             Inc y1
        EndIf
        If w1 = 0 Then
            yROOT0_READ = ySD_ByteR
        EndIf    
        If w1 = 2 Then
            yROOT2_READ = ySD_ByteR
        EndIf
        If w1 = 454 Then  '$0C6(198) + 256 = 454
            yROOT454_READ = ySD_ByteR
        EndIf
        If w1 >= 11 And w1 <= 23 Then
             yROOT_READ13[y2] = ySD_ByteR
             Inc y2
        EndIf
    Next
 
    GoSub subSD_Receive_Byte                                                       
    GoSub subSD_Receive_Byte                                   
    High sSD_CS 
    ySD_Byte5 = $FF 
    GoSub subSD_Send_Byte                                                        
    iSD_Return = sRETURN_NO_ERROR 
                                                                      
    Return  
    '********** END subSD_Read_Sector **********
    
  
    subSD_Read_Sector_MULTIBLOCK: '************************
    dSD_Sector_Num = dSECTOR_START  
    wBuffer_Size = 0                                                                
    dSD_Address = dSD_Sector_Num << 9  
    yERROR_LOOP_CNT = 0 
    
    LOOP_MULTIBLOCK:
      
    Low sSD_CS 
    ySD_Byte0 = $52   '$52 = %01 010010   '010010 = READ MULTIBLOCK (CMD 18) 
    ySD_Byte1 = dSD_Address.BYTE3 
    ySD_Byte2 = dSD_Address.BYTE2 
    ySD_Byte3 = dSD_Address.BYTE1 
    ySD_Byte4 = dSD_Address.BYTE0 
    ySD_Byte5 = $FF 
    GoSub subSD_Send_Cmd 
    ySD_Seek_Response_Reqd = $00 

    GoSub subSD_Seek_Response 
       
    If ySD_Seek_Response_Return = sRETURN_ERROR Then  
        High sSD_CS    
        Inc yERROR_LOOP_CNT
        If yERROR_LOOP_CNT < 10 Then  '10
            GoTo LOOP_MULTIBLOCK
        EndIf
      
        SerOut sSEROUT_PIN,sBAUD,["subSD_Read_Sector_MULTIBLOCK LOOPED OUT ***RESETTING***",13]
        DelayMS 100
        reset  'SD CARD REMOVED?
        iSD_Return = sRETURN_ERROR
        Return
    EndIf   
                      
    wBuffer_Size = 0 
        
    While SSPBUF <> $FE           'wait here 
        SSPBUF = $FF              'SENDS 1 BYTE TO SD
        While SSPSTAT.0 = 0: Wend 'WHILE TX/RX COMPLETE
        ySD_ByteR  = SSPBUF       'READS 1 BYTE FROM SD 
    Wend                                          
    
    iSD_Return = sRETURN_NO_ERROR

    Return     
    '********** END subSD_Read_Sector_MULTIBLOCK **********  
    
         
    subSD_STOP_READ_MULTIBLOCK: '************************
    wBuffer_Size = 0

    ySD_Byte0 = $4C    '$4C = %01 001100   '001100 = STOP READ MULTIBLOCK (CMD 12) 
    ySD_Byte1 = $FF  'dSD_Address.BYTE3 
    ySD_Byte2 = $FF  'dSD_Address.BYTE2 
    ySD_Byte3 = $FF  'dSD_Address.BYTE1 
    ySD_Byte4 = $FF  'dSD_Address.BYTE0 
    ySD_Byte5 = $FF
       
    GoSub subSD_Send_Cmd                                                      
    wSD_Seek_Response_Idx = $FFF 
    Repeat 
    GoSub subSD_Receive_Byte                                          
    Dec wSD_Seek_Response_Idx  'COUNTDOWN 4095 TO 0 UNLESS RECEIVE CORRECT RESPONSE
    Until ySD_ByteR > 0 Or wSD_Seek_Response_Idx = 0 
       
    If ySD_ByteR = 0 Then 'CORRECT RESPONSE NOT FOUND
        iSD_Return = sRETURN_ERROR
        Return                                                                                    
    EndIf 
    
    If wSD_Seek_Response_Idx = 0 Then   ' RESPONSE NOT RECEIVED 
        iSD_Return = sRETURN_ERROR
        Return
    EndIf                                           

    High sSD_CS                                
    iSD_Return = sRETURN_NO_ERROR        
      
    Return     
    '********** END subSD_STOP_READ_MULTIBLOCK **********  
    
     
    subSD_Send_Cmd: '************************
    DelayUS 10
    
    SSPBUF = ySD_Byte0        'SENDS 1 BYTE TO SD
    While SSPSTAT.0 = 0: Wend 'WHILE TX/RX COMPLETE
    ySD_ByteR  = SSPBUF       'READS 1 BYTE FROM SD                                                       
    DelayUS 10
    
    SSPBUF = ySD_Byte1        
    While SSPSTAT.0 = 0: Wend 
    ySD_ByteR  = SSPBUF                                                               
    DelayUS 10 
    
    SSPBUF = ySD_Byte2        
    While SSPSTAT.0 = 0: Wend 
    ySD_ByteR  = SSPBUF                                                         
    DelayUS 10
    
    SSPBUF = ySD_Byte3       
    While SSPSTAT.0 = 0: Wend 
    ySD_ByteR  = SSPBUF                                                            
    DelayUS 10
    
    SSPBUF = ySD_Byte4        
    While SSPSTAT.0 = 0: Wend 
    ySD_ByteR  = SSPBUF       
    DelayUS 10
                                                              
    SSPBUF = ySD_Byte5        
    While SSPSTAT.0 = 0: Wend 
    ySD_ByteR  = SSPBUF         
    DelayUS 10
                                                     
    Return 
    '********** END subSD_Send_Cmd **********      
        
          
    subSD_Send_Byte: '************************  
    SSPBUF = ySD_Byte5        'SENDS 1 BYTE TO SD
    While SSPSTAT.0 = 0: Wend 'WHILE TX/RX COMPLETE
    ySD_ByteR  = SSPBUF       'READS 1 BYTE FROM SD     
                                                      
    Return 
    '********** END subSD_Send_Byte **********  
    
      
    subSD_Seek_Response: '************************        
    wSD_Seek_Response_Idx = $FFF 
    Repeat 
        GoSub subSD_Receive_Byte  
        Dec wSD_Seek_Response_Idx  'COUNTDOWN 4095 TO 0 UNLESS RECEIVE CORRECT RESPONSE      
    Until ySD_ByteR = ySD_Seek_Response_Reqd Or wSD_Seek_Response_Idx = 0 
    If wSD_Seek_Response_Idx = 0 Then 'ERROR    CORRECT RESPONSE NOT FOUND
        ySD_Seek_Response_Return = sRETURN_ERROR      
    Else 
        ySD_Seek_Response_Return = sRETURN_NO_ERROR                                         
    EndIf 

    Return                                                            
    '********** END subSD_Seek_Response **********   
    
     
    subSD_Receive_Byte: '************************           
    SSPBUF = $FF              'SENDS 1 BYTE TO SD
    While SSPSTAT.0 = 0: Wend 'WHILE TX/RX COMPLETE
    ySD_ByteR  = SSPBUF       'READS 1 BYTE FROM SD
                                                       
    Return
    '********** END subSD_Receive_Byte **********  
        
         
    subSD_Root_Dir: '************************ 
    If iFIRSTRUN_COUNT_ALL = TRUE Then
        wFILES_TOTAL = 0
    EndIf
    
    wFILE_DISPLAY = wFILE_PLAY 

    wSD_Num_of_Root_Entries = 0 
    yROOT_ERROR_CNT = 6    
        
    ROOT_LOOP:

    dSD_Sec_Num_PLUS = wFILE_DISPLAY -1 
    dSD_Sec_Num_PLUS = dSD_Sec_Num_PLUS * 32 / 512    
    dREAD_ROOT_START_PT = wFILE_DISPLAY -1 
    dREAD_ROOT_START_PT = dREAD_ROOT_START_PT *32
    dREAD_ROOT_START_PT = dREAD_ROOT_START_PT - (dSD_Sec_Num_PLUS * 512) 
    dSD_Sector_Num = dSD_Root_Dir + dSD_Sec_Num_PLUS
       
    GoSub subSD_Read_Sector 
    
    If iSD_Return = sRETURN_ERROR Then 
        If yROOT_ERROR_CNT > 0 Then
            Dec yROOT_ERROR_CNT 
            GoTo ROOT_LOOP
        Else    
            ySD_Extended_Return_Root_Dir = sRETURN_ERROR 'ERROR
            iDISPLAY16 = FALSE  'DEFAULT
            iFIRSTRUN_COUNT_ALL = FALSE  'DEFAULT
            Return
        EndIf  
        
    EndIf

                                  '511
    'For wSD_Buffer_Pos = $000 To $1FF Step 32 
                
    '     byte(s)  contents
    '     -------  ----------------------------------------------------
    '     0-7      file name or first 8 characters of volume name
    '     8-10     file extension or last 3 characters of volume name
    '     11       attribute byte
    '     12-21    unused
    '     22-23    time
    '     24-25    date
    '     26-27    number of first cluster
    '     28-31    number of bytes in file, or zero for subdirectory or volume label
    
    yCOUNT_NULLS = 0
    For ySD_Root_Dir_File_Pos = $00 To $07  
        If ySD_Root_Dir_File32[ySD_Root_Dir_File_Pos] = $00 Then
            Inc yCOUNT_NULLS 
        EndIf
    Next

    If yCOUNT_NULLS = 8 Then
        If iFIRSTRUN_COUNT_ALL = TRUE Then
            iFIRSTRUN_COUNT_ALL = FALSE                  
            SerOut sSEROUT_PIN,sBAUD,[" **** FIRST RUN FILES_TOTAL = ", Dec wFILES_TOTAL," ****",13]
            SerOut sSEROUT_PIN,sBAUD,[" ",13]
        EndIf
        
        ySD_Extended_Return_Root_Dir = sRETURN_NO_ERROR
        iDISPLAY16 = FALSE  'DEFAULT
        iFIRSTRUN_COUNT_ALL = FALSE  'DEFAULT
        Return

    EndIf                   

    For ySD_Root_Dir_File_Pos = $00 To $07   
        y1 = ySD_Root_Dir_File32[ySD_Root_Dir_File_Pos] 'REQUIRES COPY TO BYTE THEN ADD TO STRING
        s_LCD_STRING_1plus8[ySD_Root_Dir_File_Pos +1] = y1
    Next ySD_Root_Dir_File_Pos    

    For y1 = 8 To 21   'PAD REMAINDER WITH SPACES T0 21 FOR OVERWRITE
        s_LCD_STRING_1plus8[y1 +1] = " "
    Next
        
    'ERROR TEST OF FILE NAME AND EXTENTION  
    For y1 = 0 To 10
        If ySD_Root_Dir_File32[y1] = 255 Then  ' 255 = the funny y char with .. above it
            If yROOT_ERROR_CNT > 0 Then
                Dec yROOT_ERROR_CNT
                GoTo ROOT_LOOP
            Else    
                ySD_Extended_Return_Root_Dir = sRETURN_ERROR 'ERROR
                iDISPLAY16 = FALSE  'DEFAULT
                iFIRSTRUN_COUNT_ALL = FALSE  'DEFAULT
                Return
            EndIf  
               
        EndIf                
    Next
    
    For y1 = 0 To 10 '8 CHAR FILE NAME AND 3 CHAR FILE EXT
        iBIT = FALSE
        For y2 = 65 To 90  'CAPITAL LETTERS A TO Z
            If ySD_Root_Dir_File32[y1] = y2 Then    'IF FIND 1 CHAR
                iBIT = TRUE
            EndIf
        Next
        
        For y2 = 48 To 57  'OR NUMBERS 0 TO 9    'IF FIND 1 NUMBER
            If ySD_Root_Dir_File32[y1] = y2 Then
                iBIT = TRUE
            EndIf
        Next
        
        If ySD_Root_Dir_File32[y1] = 95 Then    'IF FIND "_" CHAR 
            iBIT = TRUE
        EndIf
        
        If ySD_Root_Dir_File32[y1] = 32 Then    'IF FIND " " CHAR 
            iBIT = TRUE
        EndIf
            
        If iBIT = FALSE Then
             If yROOT_ERROR_CNT > 0 Then
                Dec yROOT_ERROR_CNT
                GoTo ROOT_LOOP
            Else    
                ySD_Extended_Return_Root_Dir = sRETURN_ERROR 'ERROR
                iDISPLAY16 = FALSE  'DEFAULT
                iFIRSTRUN_COUNT_ALL = FALSE  'DEFAULT
                
                Return
            EndIf  
         EndIf        
    Next
            
    'GET EXT    
    y2 = 0
    For y1 = 8 To 10 '8 CHAR FILE NAME AND 3 CHAR FILE EXT
        yFILE_NAME_EXT3[y2] = ySD_Root_Dir_File32[y1]
        Inc y2
    Next
     
    iWAV_EXT = FALSE  'PRESET
    If yFILE_NAME_EXT3[0] = 87 Then         '87 = "W"                 
        If yFILE_NAME_EXT3[1] = 65 Then     '82 = "A"  
            If yFILE_NAME_EXT3[2] = 86 Then '86 = "V"  
                iWAV_EXT = TRUE
            EndIf
        EndIf   
    EndIf        

    If iWAV_EXT = FALSE Then                         
        If yROOT_ERROR_CNT > 0 Then
            Dec yROOT_ERROR_CNT
            GoTo ROOT_LOOP
        Else    
            ySD_Extended_Return_Root_Dir = sRETURN_ERROR 'ERROR
            iDISPLAY16 = FALSE  'DEFAULT
            iFIRSTRUN_COUNT_ALL = FALSE  'DEFAULT

            Return
        EndIf    
    EndIf   

    ySD_Extended_Return_Root_Dir = sRETURN_NO_ERROR
    GoSub subSD_Open_File_Sub

    If iFIRSTRUN_COUNT_ALL = TRUE Then
        SerOut sSEROUT_PIN,sBAUD,[" FILE CNT ",Dec wFILES_TOTAL +1," ["]
        For y1 = 0 To 8 
            st_STRING_1_CHAR = s_LCD_STRING_1plus8[y1]
            SerOut sSEROUT_PIN,sBAUD,[st_STRING_1_CHAR]
        Next
        SerOut sSEROUT_PIN,sBAUD,["]",13] 
    Else     
        SerOut sSEROUT_PIN,sBAUD,[" PLAY FILE ",Dec wFILE_PLAY," ["]
        For y1 = 0 To 8 
            st_STRING_1_CHAR = s_LCD_STRING_1plus8[y1]
            SerOut sSEROUT_PIN,sBAUD,[st_STRING_1_CHAR]
        Next
        SerOut sSEROUT_PIN,sBAUD,["]",13]
    EndIf
      
    If iFIRSTRUN_COUNT_ALL = FALSE And iDISPLAY16 = FALSE Then
         ySD_Extended_Return_Root_Dir = sRETURN_NO_ERROR
        iDISPLAY16 = FALSE  'DEFAULT  
        iFIRSTRUN_COUNT_ALL = FALSE  'DEFAULT
        Return
    EndIf    
    
    If iFIRSTRUN_COUNT_ALL = TRUE And wFILES_TOTAL  = 512 Then
        iFIRSTRUN_COUNT_ALL = FALSE 
        SerOut sSEROUT_PIN,sBAUD,[" **** FIRST RUN FILES_TOTAL MAXED = ", Dec wFILES_TOTAL," ****",13]
        SerOut sSEROUT_PIN,sBAUD,[" ",13]
        Return
    EndIf    

    If iFIRSTRUN_COUNT_ALL = TRUE Then
        Inc wFILES_TOTAL
    EndIf
         
    Inc wFILE_DISPLAY

    GoTo ROOT_LOOP 
    
    Return 
    '********** END subSD_Root_Dir **********      
    

    subSD_Open_File_Sub: '************************ 
    If ySD_Extended_Return_Root_Dir <> 0 Then  
        iSD_Extended_Return = sRETURN_ERROR                                             
        Return                                                                     
    EndIf 
    
    wSD_Cluster_Num.BYTE0 = ySD_Root_Dir_File32[$1A]                                 
    wSD_Cluster_Num.BYTE1 = ySD_Root_Dir_File32[$1B] 
                
    dSD_File_Size.BYTE0 = ySD_Root_Dir_File32[$1C]                                   
    dSD_File_Size.BYTE1 = ySD_Root_Dir_File32[$1D] 
    dSD_File_Size.BYTE2 = ySD_Root_Dir_File32[$1E] 
    dSD_File_Size.BYTE3 = ySD_Root_Dir_File32[$1F]
               
    dSD_Data_Sec = (wSD_Cluster_Num - 2) * ySD_Secs_Per_Cluster                     
    dSD_Data_Sec = dSD_Data_Sec + dSD_Data_Area 
     
    dSD_Sector_Num = dSD_Data_Sec
    dSECTOR_START = dSD_Data_Sec 

    If iSD_Return = sRETURN_ERROR Then 
        iSD_Extended_Return = sRETURN_ERROR                                                
        Return                                                                     
    EndIf 

    iSD_Extended_Return = sRETURN_NO_ERROR
                                                          
    Return           
    '********** END subSD_Open_File_Sub **********
       
       
    sub_READOUT_ALL_FILES_TO_GLCD: '************************
    
    GoSub subSD_Root_Dir 
        
    Return 
    '********** END sub_READOUT_ALL_FILES_TO_GLCD **********
 
        
    
    '***********************************************
    '***********************************************
    '***********************************************
    START:
    
    DelayMS 800
    GoSub subINIT_SD
      
    wFILE_PLAY = 1

    GoSub sub_READOUT_ALL_FILES_TO_GLCD
    wFILE_PLAY = 0
        
    MAIN:     
 
    If iMENU_PLAY_BUTTON_UP = TRUE Then
        If sMENU_PLAY_BUTTON = 0 Then 
            iMENU_PLAY_BUTTON_UP = FALSE

            If wFILE_PLAY < wFILES_TOTAL Then
                Inc wFILE_PLAY
            Else 
                wFILE_PLAY = 1      
            EndIf
            
            GoSub subSD_Root_Dir       
            GoSub subPLAY_WAV_SD
        EndIf 
    Else
        If sMENU_PLAY_BUTTON = 1 Then 
            iMENU_PLAY_BUTTON_UP = TRUE
        EndIf     
    EndIf
    
    GoTo MAIN    
    
    End 

